jQuery( document ).ready(function($) {
    $('#international-edition').hide();

    $('#searchlink').on('click', function(e) {
    	$(this).toggleClass('open');
    });
});


jQuery(document).ready(function($){
    $('#international-edition-trigger').click(function (e) {
        e.preventDefault();
        if ($(this).hasClass('active')) {
            $('.flyout-menu').hide();
            $('#searchbar').show();
            $(this).removeClass('active');
        } else {
            $('.flyout-menu').show();
            $('#searchbar').hide();
            $(this).addClass('active');
            $(document).off('mouseup').on('mouseup', function (e) {
                var container = $(".flyout-menu");
                if (!container.is(e.target) && container.has(e.target).length === 0)
                {
                    container.hide();
                    $('#searchbar').show();
                    $('#international-edition-trigger').removeClass('active');
                }
            });
        }
    });

    $('#international-edition .flyout-close').click(function (e) {
        e.preventDefault();
        $('#international-edition-trigger').trigger('click');
    });
});

//Continent search header location
jQuery(document).ready(function($){
    // On load loading the select box based on cookie
    var continentdata = getCookie("selected_continent");
    // if( continentdata ) {
    //     $('#continent_'+continentdata).show();
    // }
    //Select on change continent
    $(".country_selector_continent").on('click', function() {
        $("ul.region-map-list li").removeClass("active");
        jQuery(this).parent('li').addClass('active');
        var continent = $(this).attr('data-continent');
        $('.country-selects select').hide();
        $('#continent_'+continent).show();

        setsessionwithwp("selected_continent", continent );

        $.removeCookie('selected_continent', { path: '/' });
        $.cookie("selected_continent", continent);
        $.session.set('selected_continent', continent);
        console.log(getCookie("selected_continent"));
    });
    //getting and storing the change of country from the select and storing in cookie
    $('.country-selects select').on('change', function() {
        var newcontinent = this.value;
        var countrycode = $(this).find(':selected').data('code');
        setsessionwithwp("selected_country", newcontinent );
        setsessionwithwp("country_code", countrycode );
        $.removeCookie('selected_country', { path: '/' });
        $.cookie("selected_country", newcontinent);
        $.session.set("selected_country", newcontinent);
        $.session.set("country_code", countrycode);
        console.log(getCookie("selected_country"));
    });

    //go button on click 
    $("#commit-page-selector-button").on('click', function(){
        
        var continentdata = getCookie("selected_continent");

        if ( continentdata === "undefined") {
            var continentdata = $.session.get('selected_continent');
        }

        if( continentdata ) {
             $('#continent_'+continentdata).show();
             var continentId = '#continent_'+continentdata;
        }
        // var sitedomain = $("#site_domain_url").val();
        // var country = $(continentId).val();
        // var gametype = $("#game-type").val();
        // var actiontype = $("#country_actiontype").val();
        // var sitedomain = $("#site_domain_url").val();
        // alert(country);

        var country = $(continentId).val();
        var continent = $(continentId).attr('data-code');
        var gametype = $("#game-type").val();
        var actiontype = $("#country_actiontype").val();

        jQuery.ajax({
            type: "post",
            // dataType: "json",
            url: ajax_object.ajax_url,
            data: {
                "action" : "location_search_url",
                "country" : country,
                "gametype" : gametype,
                "actiontype" : actiontype,
            },
            success: function(msg){
                window.location.replace(msg);
            }
        });



        // var url_based_on_selection = sitedomain+"/"+country+"/"+gametype+"/"+gametype+"-"+actiontype;
        // window.location.replace(url_based_on_selection);
    });
    $("a.select-country-data").on('click', function(){
        var countryCode = $(this).attr('data-code');
        var countryName= $(this).attr('data-country');
        var continentName = $(this).attr('data-continent');
        var dataLanguage = $(this).attr('data-language');
        var dataPath = $(this).attr('data-value');
        jQuery.ajax({
            type: "post",
            // dataType: "json",
            url: ajax_object.ajax_url,
            data: {
                "action" : "country_selector_url",
                "countrycode" : countryCode,
                "countryname" : countryName,
                "continentname " : continentName,
                "datalanguage" : dataLanguage,
                "datapath" : dataPath,

            },
            success: function(msg){                
		window.location.replace(msg);
            }
        });
    });
});
/*This file was exported by "Export WP Page to Static HTML" plugin which created by ReCorp (https://myrecorp.com) */